package org.msh.tb.adminunits.latlng;

import org.apache.commons.io.IOUtils;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.utils.JsonUtils;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mauri on 27/06/2017.
 * Service that access google API to return Latitude and Longitude of a administrative unit based on its full name
 */
public class GoogleApiLatLonService {

    /**
     * Sets into au param the latitude and longitude returned from google if google returns only one result for that Administrative unit.
     * If returns 2 or more results means that the lat lng may not be correct
     * @param au
     */

    /**
     * Sets into au param the latitude and longitude returned from google if google returns only one result for that Administrative unit.
     * If returns 2 or more results means that the lat lng may not be correct and will be not considered
     * @param au
     * @return true if latlng was found
     */
    public static boolean setLatLgn(AdministrativeUnit au) {
        String jsonRet = getLatLong(au.getFullDisplayName2().replace(" ", ""));

        Map<String, Object> mapRet = JsonUtils.parseString(jsonRet);
        ArrayList<Object> results = (ArrayList<Object>) mapRet.get("results");

        if (results.size() == 1) {
            // set latlgn
            LinkedHashMap firstResult = (LinkedHashMap) results.get(0);
            LinkedHashMap latlng = (LinkedHashMap) ((LinkedHashMap) firstResult.get("geometry")).get("location");
            Double lat = (Double) latlng.get("lat");
            Double lng = (Double) latlng.get("lng");

            au.setLatitude(lat);
            au.setLongitude(lng);

            return true;
        }

        return false;
    }

    /**
     * Returns json response from google
     * @param address
     * @return
     */
    public static String getLatLong(String address) {

        HttpURLConnection getConn = null;
        String jsonRet = null;

        try {

            // get GET connection
            getConn = getGetConnection(address);

            // request
            checkHttpCode(getConn.getResponseCode());

            // read response - response should be the data element required fields to send a PUT request
            jsonRet = IOUtils.toString(getConn.getInputStream(), "UTF-8");

        }catch (Exception e){
            e.printStackTrace();
        } finally {
            if (getConn != null) {
                getConn.disconnect();
            }
        }

        return jsonRet;
    }

    /**
     * Returns configured get connection, ready to request Google LatLong service
     * @return
     */
    protected static HttpURLConnection getGetConnection(String address) {
        // get parameter to send request
        String serverUrl = "http://maps.googleapis.com/maps/api/geocode/";

        HttpURLConnection conn = null;

        try {
            // mount URL
            String urlString = serverUrl + "json?address=" + address;

            // Instantiate URL
            URL url = new URL(urlString);

            // open connection
            conn = (HttpURLConnection) url.openConnection();

            // parametrize Request
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");

        } catch (Exception e) {
            if (conn != null) {
                conn.disconnect();
            }

            throw new RuntimeException(e);
        }

        return conn;
    }

    /**
     * Checks http code returned by Google server
     * @param responseCode
     */
    protected static void checkHttpCode(int responseCode) {
        if (responseCode != 200) {
            switch (responseCode) {
                case 404:
                    throw new RuntimeException("service not found");
                default:
                    throw new RuntimeException("Failed to request parent server: HTTP error code " + responseCode);
            }
        }
    }

}
